# ********************************************************
# * [概      要]TcpTrigger結果判定
# * [パラメータ]1:ファイルフルパス
# * [戻  り  値]1:実行結果(数値) ////0:正常、1:異常(0バイトファイル)、2:異常(TcpTrigger自体のエラー)
# ********************************************************

#引数セット
$file = $args[0]

#ファイルが0バイトか判定
$file_size = (Get-Item $file).Length
if ($file_size -eq 0) {
	#0バイトファイルなので異常
	#Write-Host empty
	exit 1
}

#ファイル内に、Exception もしくは Error が存在すれば異常
$textChk = Select-String -Path $file -Pattern "Exception","Error" -quiet
if ($textChk -eq $True) {
	#存在する
	#Write-Host Exists
	exit 2
} else {
	#存在しない
	exit 0
}

